<?php
/*
Common Setup for "Target" Archery
*/

require_once(dirname(__FILE__).'/lib.php');
require_once(dirname(dirname(__FILE__)).'/lib.php');

// default Divisions
CreateStandardDivisions($TourId,$TourType);

// default SubClasses
CreateSubClass($TourId, 1, 'NZ', 'New Zealand');
CreateSubClass($TourId, 2, 'IN', 'International');
CreateSubClass($TourId, 3, 'OP', 'Open');

// default Classes
CreateStandardClasses($TourId, $SubRule);

// default Distances
switch($TourType) {
	case 1: //WA-1440 (FITA)
	case 4: //FITA-72
		switch($SubRule) {
			case '1':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				break;
			case '2':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				break;
			case '3':
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10)));
				break;
		}
		break;
	case 2: //2xWA-1440 (DblFITA)
		switch($SubRule) {
			case '1':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				break;
			case '2':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				break;
			case '3':
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('90m-1',90), array('70m-2',70), array('50m-3',50), array('30m-4',30), array('90m-5',90), array('70m-6',70), array('50m-7',50), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('70m-1',70), array('60m-2',60), array('50m-3',50), array('40m-4',40), array('70m-5',70), array('60m-6',60), array('50m-7',50), array('40m-8',40)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('55m-1',55), array('45m-2',45), array('35m-3',35), array('25m-4',25), array('55m-5',55), array('45m-6',45), array('35m-7',35), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('60m-1',60), array('50m-2',50), array('40m-3',40), array('30m-4',30), array('60m-5',60), array('50m-6',50), array('40m-7',40), array('30m-8',30)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('40m-1',40), array('35m-2',35), array('30m-3',30), array('25m-4',25), array('40m-5',40), array('35m-6',35), array('30m-7',30), array('25m-8',25)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('35m-1',35), array('30m-2',30), array('25m-3',25), array('20m-4',20), array('35m-5',35), array('30m-6',30), array('25m-7',25), array('20m-8',20)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('25m-1',25), array('20m-2',20), array('15m-3',15), array('10m-4',10), array('25m-5',25), array('20m-6',20), array('15m-7',15), array('10m-8',10)));
				break;
		}
		break;
	case 3: //WA-720
		switch($SubRule) {
			case '1':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('20m-1',20), array('20m-2',20)));
				break;
			case '2':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('50m-1',50), array('50m-2',50)));
			case '3':
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('70m-2',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('60m-2',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('45m-1',45), array('45m-2',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('20m-1',20), array('20m-2',20)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('50m-1',50), array('50m-2',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('35m-1',35), array('35m-2',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('30m-1',30), array('30m-2',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('20m-1',20), array('20m-2',20)));
				break;
		}
		break;
	case 5: //WA-900
		CreateDistanceNew($TourId, $TourType, '%', array(array('60 m',60), array('50 m',50), array('40 m',40)));
		break;
	case 6: //WA-18m
		CreateDistanceNew($TourId, $TourType, '%', array(array('18m-1',18), array('18m-2',18)));
		break;
	case 7: //WA-25m
		CreateDistanceNew($TourId, $TourType, '%', array(array('25m-1',25), array('25m-2',25)));
		break;
	case 8: //WA-25m+18m
		CreateDistanceNew($TourId, $TourType, '%', array(array('25m-1',25), array('25m-2',25), array('18m-1',18), array('18m-2',18)));
		break;
	case 34: //WA-1440+WA-720
		switch($SubRule) {
			case '1':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				break;
			case '2':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				break;
			case '3':
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-70m-5',70), array('720-70m-6',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-60m-5',60), array('720-60m-6',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('1440-90m-1',90), array('1440-70m-2',70), array('1440-50m-3',50), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('1440-70m-1',70), array('1440-60m-2',60), array('1440-50m-3',50), array('1440-30m-4',40), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('1440-55m-1',55), array('1440-45m-2',45), array('1440-35m-3',35), array('1440-25m-4',25), array('720-45m-5',45), array('720-45m-6',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('1440-60m-1',60), array('1440-50m-2',50), array('1440-40m-3',40), array('1440-30m-4',30), array('720-50m-5',50), array('720-50m-6',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('1440-40m-1',40), array('1440-35m-2',35), array('1440-30m-3',30), array('1440-25m-4',25), array('720-35m-5',35), array('720-35m-6',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('1440-35m-1',35), array('1440-30m-2',30), array('1440-25m-3',25), array('1440-20m-4',20), array('720-30m-5',30), array('720-30m-6',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('1440-25m-1',25), array('1440-20m-2',20), array('1440-15m-3',15), array('1440-10m-4',10), array('720-20m-5',20), array('720-20m-6',20)));
				break;
		}
		break;
	case 35; //NZ-Clout
		CreateDistanceNew($TourId, $TourType, 'R65M', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'R50M', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'RM', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'RD', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'RN', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'R65W', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'R50W', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'RW', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'C65M', array(array('185m',185)));
		CreateDistanceNew($TourId, $TourType, 'C50M', array(array('185m',185)));
		CreateDistanceNew($TourId, $TourType, 'CM', array(array('185m',185)));
		CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('185m',185)));
		CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'CD', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'CN', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'C65W', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'C50W', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'CW', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('165m',165)));
		CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'B65M', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'B50M', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'BM', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('145m',145)));
		CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'BD', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'BN', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'B65W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'B50W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'BW', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'T65M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'T50M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TM', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'TD', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'TN', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'T65W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'T50W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TW', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'L65M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'L50M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LM', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'LD', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'LN', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'L65W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'L50W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LW', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('120m',120)));
		CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('80m',80)));
		CreateDistanceNew($TourId, $TourType, 'X%',array(array('185m',185)));
		break;
    case 37: //2xWA-720 (Dbl720)
        switch($SubRule) {
            case '1':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
                break;
            case '2':
				CreateDistanceNew($TourId, $TourType, 'R65M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'R50M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RM', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RD', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'RN', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'R65W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'R50W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RW', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'C65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'C50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CD', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CN', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'C65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'C50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'B65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'B50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BD', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'BN', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'B65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'B50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'T65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'T50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TD', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'TN', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'T65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'T50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'L65M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'L50M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LM', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LD', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'LN', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'L65W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'L50W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LW', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				break;
            case '3':
				CreateDistanceNew($TourId, $TourType, 'RU21M', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18M', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16B', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'RU21W', array(array('70m-1',70), array('70m-2',70), array('70m-3',70), array('70m-4',70)));
				CreateDistanceNew($TourId, $TourType, 'RU18W', array(array('60m-1',60), array('60m-2',60), array('60m-3',60), array('60m-4',60)));
				CreateDistanceNew($TourId, $TourType, 'RU16G', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'RU14G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'RU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'CU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16B', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'CU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'CU16G', array(array('45m-1',45), array('45m-2',45), array('45m-3',45), array('45m-4',45)));
				CreateDistanceNew($TourId, $TourType, 'CU14G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'CU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14B', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'BU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'BU16G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'BU14G', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'BU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14B', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'TU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'TU16G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'TU14G', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'TU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LU21M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18M', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16B', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14B', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11B', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				CreateDistanceNew($TourId, $TourType, 'LU21W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU18W', array(array('50m-1',50), array('50m-2',50), array('50m-3',50), array('50m-4',50)));
				CreateDistanceNew($TourId, $TourType, 'LU16G', array(array('35m-1',35), array('35m-2',35), array('35m-3',35), array('35m-4',35)));
				CreateDistanceNew($TourId, $TourType, 'LU14G', array(array('30m-1',30), array('30m-2',30), array('30m-3',30), array('30m-4',30)));
				CreateDistanceNew($TourId, $TourType, 'LU11G', array(array('20m-1',20), array('20m-2',20), array('20m-3',20), array('20m-4',20)));
				break;
        }
        break;
}

// call creation of standard NZ matchplay competition events for Outdoor (3,37) and Indoor (6,7,8) rounds
if($TourType==3 or $TourType==6 or $TourType==7 or $TourType==8 or $TourType==37) {
	// Standard Matchplay Events
	CreateStandardEvents($TourId, $SubRule, in_array($TourType,array(3,37)), in_array($TourType,array(3,6,7,8,37)));

	// Classes in Events
	InsertStandardEvents($TourId, $SubRule);

	// Finals & TeamFinals
	CreateFinals($TourId);
}

// Default Target
switch($TourType) {
	// function expects ($TourId, $Id, $Name, $Classes, $Default, $T1, $W1, $T2=0, $W2=0, etc.)
	/*
		IANSEO Target Faces: ($Tn)
		1 - Indoor (1-big 10)
		2 - Indoor (6-big 10)
		3 - Indoor (1-small 10)
		4 - Indoor (6-small 10)
		5 - Outdoor (1-X)
		6 - Field Archery
		7 - Hit-Miss
		8 - 3D Standard
		9 - Outdoor (5-X)
		10 - Outdoor (6-X)
	*/
	case 1: //WA-1440 (FITA)
		switch ($SubRule)  {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'R50M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RM', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RD', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RN', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R50W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RW', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'C50M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CM', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C50W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CW', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BM', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BW', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TM', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TW', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LM', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LW', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'R50M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RM', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RD', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RN', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R50W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RW', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'C50M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CM', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C50W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CW', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BM', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BW', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TM', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TW', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LM', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LD', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LN', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LW', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80);
				break;
		}
		break;
	case 2: //2xWA-1440 (DblFITA)
		switch($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'R50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RD', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RN', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'C50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'R50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RD', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RN', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'R50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'C50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'C50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'B50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'T50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'L50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, '90m WA1440', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'RU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'RU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'RU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '90m WA1440', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '70m WA1440', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m WA1440', 'CU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'CU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'CU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'BU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'BU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'BU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'TU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'TU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'TU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m WA1440', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m WA1440', 'LU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA1440', 'LU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m WA1440', 'LU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122, 5, 80, 5, 80);
				break;
		}
		break;
	case 3:  //WA-720
		switch($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'RD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CM', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16B', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CD', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14B', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11B', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CW', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16G', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14G', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11G', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11G', '1', 5, 122, 5, 122);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'RD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CM', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CD', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CW', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LM', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LD', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LN', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LW', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18W', '1', 5, 122, 5, 122);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18M', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16B', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14B', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11B', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18W', '1', 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16G', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14G', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11G', '1', 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18M', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11B', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18W', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14G', '1', 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11G', '1', 5, 122, 5, 122);
				break;
		}
		break;
	case 4: //WA_72
		CreateTargetFace($TourId, 1, '~Default', '%', '1', 5, 122, 5, 122, 5, 80, 10, 80);
		break;
	case 5: //WA-900
		CreateTargetFace($TourId, 1, '~Default', '%', '1',  5, 122, 5, 122, 5, 122);
		break;
	case 6: //WA-18m
		switch($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R65%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R50%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RM', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RW', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RD', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RN', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C65%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C50%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CM', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CW', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CD', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CN', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU16%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU16%', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU14%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU14%', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU11%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU11%', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot opt', '%', '0', 2, 40,  2, 40);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R65%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R50%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RM', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RW', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RD', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RN', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C65%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C50%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CM', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CW', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CD', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CN', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 40,  3, 40);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU16%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU16%', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU14%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU14%', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU11%', '1', 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU11%', '1', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot opt', '%', '0', 2, 40,  2, 40);
				break;
		}
		break;
	case 7: //WA-25m
		switch($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R65%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R50%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RM', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RW', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RD', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RN', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C65%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C50%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CM', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CW', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CD', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CN', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU16%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU16%', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU14%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU14%', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU11%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU11%', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot opt', '%', '0', 2, 60,  2, 60);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R65%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R50%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RM', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RW', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RD', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RN', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C65%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C50%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CM', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CW', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CD', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CN', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 60,  3, 60);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 60,  2, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 60,  4, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU16%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU16%', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU14%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU14%', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU11%', '1', 1, 60,  1, 60);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU11%', '1', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 60,  3, 60);
				CreateTargetFace($TourId, $i++, 'Triple Spot opt', '%', '0', 2, 60,  2, 60);
				break;
		}
		break;
	case 8: //WA-25m+18m
		switch ($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R65%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R50%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RM', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RW', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RD', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RN', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C65%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C50%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CM', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CW', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CD', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CN', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU16%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU16%', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU14%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU14%', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU11%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU11%', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot opt', '%', '0', 2, 60,  2, 60, 2, 40,  2, 40);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R65%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'R50%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RM', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RW', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RD', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RN', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C65%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'C50%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CM', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CW', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CD', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CN', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 60,  3, 60, 3, 40,  3, 40);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU21%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot R', 'RU18%', '1', 2, 60,  2, 60, 2, 40,  2, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU21%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot C', 'CU18%', '1', 4, 60,  4, 60, 4, 40,  4, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'B%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'T%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'L%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU16%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU16%', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU14%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU14%', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face R', 'RU11%', '1', 1, 60,  1, 60, 1, 40,  1, 40);
				CreateTargetFace($TourId, $i++, 'Full Face C', 'CU11%', '1', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'R%', '0', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Full Face opt', 'C%', '0', 3, 60,  3, 60, 3, 40,  3, 40);
				CreateTargetFace($TourId, $i++, 'Triple Spot opt', '%', '0', 2, 60,  2, 60, 2, 40,  2, 40);
				break;
		}
		break;
	case 34: //WA-1440+WA-720
		switch ($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'R65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/60m RR', 'R50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '90m 1440/70m RR', 'RM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '90m 1440/70m RR', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/60m RR', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'RU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'RD', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'RU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'RN', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'RU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'R65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'R50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/70m RR', 'RW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/70m RR', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'RU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'RU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'RU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'C65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'C50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m 1440/50m RR', 'CM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m 1440/50m RR', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'CU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'CD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'CU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'CN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'CU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'C65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'C50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'CU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'CU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'CU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'BU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'BD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'BU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'BN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'BU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'BU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'BU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'BU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'TU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'TD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'TU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'TN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'TU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'TU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'TU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'TU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'LU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'LD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'LU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'LN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'LU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'LU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'LU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'LU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'R65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/60m RR', 'R50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '90m 1440/70m RR', 'RM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '90m 1440/70m RR', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/60m RR', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'RD', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'RN', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'R65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'R50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/70m RR', 'RW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/70m RR', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'C65M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'C50M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m 1440/50m RR', 'CM', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '90m 1440/50m RR', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'CD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'CN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'C65W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'C50W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CW', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'BD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'BN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'B50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'TD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'TN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'T50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L65M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L50M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LM', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'LD', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'LN', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L65W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'L50W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LW', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, '90m 1440/70m RR', 'RU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/60m RR', 'RU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'RU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'RU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'RU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m 1440/70m RR', 'RU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/60m RR', 'RU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'RU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'RU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'RU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '90m 1440/50m RR', 'CU21M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CU18M', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'CU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'CU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'CU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '70m 1440/50m RR', 'CU21W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'CU18W', '1', 5, 122, 5, 122, 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '55m 1440/45m RR', 'CU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'CU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'CU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'BU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'BU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'BU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'BU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'BU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'BU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'BU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'TU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'TU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'TU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'TU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'TU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'TU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'TU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU21M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU18M', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'LU16B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'LU14B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'LU11B', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU21W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m 1440/50m RR', 'LU18W', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '40m 1440/35m RR', 'LU16G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m 1440/30m RR', 'LU14G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '25m 1440/20m RR', 'LU11G', '1', 5, 122, 5, 122, 5, 80, 5, 80, 5, 122, 5, 122);
				break;
		}
		break;
	case 35; //NZ-Clout
		$i=1;
		CreateTargetFace($TourId, $i++, '165m', 'R65M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'R50M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'RM', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'RU21M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'RU18M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'RU16B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'RD', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'RU14B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'RN', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'RU11B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'R65W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'R50W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'RW', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'RU21W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'RU18W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'RU16G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'RU14G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'RU11G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '185m', 'C65M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '185m', 'C50M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '185m', 'CM', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '185m', 'CU21M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'CU18M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'CU16B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'CD', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'CU14B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'CN', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'CU11B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'C65W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'C50W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'CW', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '165m', 'CU21W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'CU18W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'CU16G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'CU14G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'CU11G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'B65M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'B50M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'BM', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '145m', 'BU21M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'BU18M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BU16B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BD', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BU14B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BN', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BU11B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'B65W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'B50W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'BW', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'BU21W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'BU18W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BU16G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BU14G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'BU11G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'T65M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'T50M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'TM', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'TU21M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'TU18M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TU16B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TD', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TU14B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TN', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TU11B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'T65W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'T50W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'TW', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'TU21W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'TU18W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TU16G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TU14G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'TU11G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'L65M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'L50M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'LM', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'LU21M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'LU18M', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LU16B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LD', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LU14B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LN', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LU11B', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'L65W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'L50W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'LW', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'LU21W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '120m', 'LU18W', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LU16G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LU14G', '1', 17, 7500);
		CreateTargetFace($TourId, $i++, '80m', 'LU11G', '1', 17, 7500);
		break;
    case 37: //2xWA-720 (Dbl720)
		switch ($SubRule) {
			case '1':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'RD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CM', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16B', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CD', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14B', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11B', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CW', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16G', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14G', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11G', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				break;
			case '2':
				$i=1;
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'RD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'R50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CM', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CD', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C65W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'C50W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CW', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'B50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'T50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LM', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LD', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LN', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L65W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'L50W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LW', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				break;
			case '3':
				$i=1;
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '70m WA720', 'RU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '60m WA720', 'RU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '45m WA720', 'RU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'RU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'RU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18M', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16B', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14B', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11B', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU21W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'CU18W', '1', 9, 80, 9, 80, 9, 80, 9, 80);
				CreateTargetFace($TourId, $i++, '45m WA720', 'CU16G', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '35m WA720', 'CU14G', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '20m WA720', 'CU11G', '1', 5, 80, 5, 80, 5, 80, 5, 80);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'BU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'BU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'BU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'BU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'TU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'TU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'TU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'TU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18M', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11B', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU21W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '50m WA720', 'LU18W', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '35m WA720', 'LU16G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '30m WA720', 'LU14G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				CreateTargetFace($TourId, $i++, '20m WA720', 'LU11G', '1', 5, 122, 5, 122, 5, 122, 5, 122);
				break;
		}
		break;
}

// create a first distance prototype
CreateDistanceInformation($TourId, $DistanceInfoArray, 24, 4);

// Update Tour details
$tourDetails=array(
	'ToCollation' => $tourCollation,
	'ToTypeName' => $tourDetTypeName,
	'ToNumDist' => $tourDetNumDist,
	'ToNumEnds' => $tourDetNumEnds,
	'ToMaxDistScore' => $tourDetMaxDistScore,
	'ToMaxFinIndScore' => $tourDetMaxFinIndScore,
	'ToMaxFinTeamScore' => $tourDetMaxFinTeamScore,
	'ToCategory' => $tourDetCategory,
	'ToElabTeam' => $tourDetElabTeam,
	'ToElimination' => $tourDetElimination,
	'ToGolds' => $tourDetGolds,
	'ToXNine' => $tourDetXNine,
	'ToGoldsChars' => $tourDetGoldsChars,
	'ToXNineChars' => $tourDetXNineChars,
	'ToDouble' => $tourDetDouble,
//	'ToIocCode'	=> $tourDetIocCode,
	);
UpdateTourDetails($TourId, $tourDetails);

?>
